//OHSAT GAMES MEGASAMPLER
//MEGATEAMWORK Makes the MEGADREAM Work 

//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include "menu.h"
#include "megapong.h"
#include "megarunner.h"
#include "megalaga.h"
#include "megatiler.h"

int main()
{
    while(1)
    {
        int choice = menu_show();   // Returns 1–4

        switch(choice)
        {
            case 1:
                runMegapong();
                break;
            case 2:
                runMegarunner();
                break;
            case 3:
                runMegalaga();
                break;
            case 4:
                runMegatiler();
                break;
        }

        //
        // CLEAN RESET BETWEEN GAMES
        //
        XGM_stopPlay();             // stop any XGM music
        SND_PCM_stopPlay();        // stop PCM channel (optional)
        SPR_reset();                // remove all sprite engine data
        VDP_resetScreen();          // clear VRAM + planes
        JOY_setEventHandler(NULL);  // clear input callbacks
    }

    return 0;
}



/////////////////////NOTES///////////////////////

/*

1. The asset management in this is a mess. For your own project, 
I recommend that you plan out your resource usage a little better. 

Because this was a quick cobbling together of projects done independently 
over the course of a year or so the code and resource management wasn't 
intended to be cobbled together like this. 

However, I did want to highlite using switch statement and what better way to
build on what Andrej has taught us by cramming everything together in an
unslightly mess of code, amirite? 

2. This project was coded using SGDK version 2.0. Functions that worked in previous
versions are now depracated. I meant to comment out the depracated code for reference
but accidentally deleted it but the SND_PCM_stopPlay(); is different than how it was 
used in older versions of SGDK. Also a lot of VDP_setPalette stuff was changed to PAL_setPalette
instead.

3. I've incorporated knowledge from the Pigsy Retro Game Dev tutorials into these tutorials as well.
Show him some love as well but also keep in mind that he's currently using a newer version of SGDK
than what I'm using (v 2.11 April 2025 release). I need to bite the bullet and update but if you're 
jumping from his tutorials to mine you'll notice that my fix32ToInt is F32toInt in his code. 

*/

//////////////////////////////////////////////////

/////////////////EXPERIMENTATION IDEAS////////////

/*




*/

///////////////////////////////////////////////////

//////////////ERROR HANDLING///////////////////////

/*



*/

////////////////////////////////////////////////////